package com.agilex.healthcare.directscheduling.dao;

import com.agilex.healthcare.directscheduling.db.PatientResultSetRowMapper;
import com.agilex.healthcare.directscheduling.db.PatientStoredProcedure;
import com.agilex.healthcare.directscheduling.domain.FacilityMember;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PatientRelationshipDaoImpl implements PatientRelationshipDao {

	private PatientStoredProcedure patientStoredProcedure;
	private JdbcTemplate jdbcTemplate;
	private String storedProcedure;
	private PatientResultSetRowMapper patientResultSetRowMapper;

	public void initStoredProcedure() {
		patientStoredProcedure = new PatientStoredProcedure(jdbcTemplate, storedProcedure, patientResultSetRowMapper);
	}

	@Override
	public <T extends FacilityMember> Collection<T> getPatientData(Map<String, Object> inputParamsMap) {
		Map<String, Object> storedProcedureResults = getStoredProcedureResults(inputParamsMap);
		@SuppressWarnings("unchecked")
		Collection<T> facilityMembers = (Collection<T>)getFacilityTeamMembers(storedProcedureResults);
		return facilityMembers;
	}

	private Map<String, Object> getStoredProcedureResults(Map<String, Object> inputParamsMap) {
		return patientStoredProcedure.getStoredProcedureResults(inputParamsMap);
	}

	private Collection<FacilityMember> getFacilityTeamMembers(Map<String, Object> data) {
		@SuppressWarnings("unchecked")
		List<FacilityMember> teamResults = (List<FacilityMember>) data.get(DAOConstants.RESULT_LIST);
		return teamResults;
	}

	public PatientStoredProcedure getPatientSP() {
		return patientStoredProcedure;
	}

	public void setPatientClinicRelationshipSP(PatientStoredProcedure patientStoredProcedure) {
		this.patientStoredProcedure = patientStoredProcedure;
	}

	public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
		this.jdbcTemplate = jdbcTemplate;
	}

	public JdbcTemplate getJdbcTemplate() {
		return (jdbcTemplate);
	}

	public void setStoredProcedure(String storedProcedure) {
		this.storedProcedure = storedProcedure;
	}

	public String getStoredProcedure() {
		return (this.storedProcedure);
	}

	public PatientResultSetRowMapper getPatientRowMapper() {
		return patientResultSetRowMapper;
	}

	public void setPatientResultSetRowMapper(PatientResultSetRowMapper patientResultSetRowMapper) {
		this.patientResultSetRowMapper = patientResultSetRowMapper;
	}
}
